﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

using System.IO;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Spreadsheet;
using DocumentFormat.OpenXml;

using Framework;

namespace Framework.Tools.OpenXmlHelpers
{
    public class XlsxSheet
    {
        readonly XlsxBook _book = null;
        readonly WorksheetPart _wsPart = null;
        readonly Sheet _sheet = null;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public XlsxSheet(XlsxBook book, WorksheetPart wsPart, Sheet sheet)
        {
            _book = book;
            _wsPart = wsPart;
            _sheet = sheet;
        }

        /// <summary>
        /// SheetData
        /// </summary>
        public SheetData SheetData
        {
            get
            {
                if (_sheetData == null)
                {
                    _sheetData = _wsPart.Worksheet.GetFirstChild<SheetData>();
                }
                return _sheetData;
            }
        }
        private SheetData _sheetData = null;

        /// <summary>
        /// シート名
        /// </summary>
        public string SheetName
        {
            get {return _sheet.Name;}
            set 
            {
                if (_book.Sheets(value) == null)
                {
                    _sheet.Name = value;
                }
            }
       }

        /// <summary>
        /// 保存します。
        /// </summary>
        public void Save()
        {
            _wsPart.Worksheet.Save();
        }

        /// <summary>
        /// アクティブシートにします。
        /// </summary>
        public void Activate()
        {
            _book.ActiveSheet = this;
        }

        /// <summary>
        /// Cell
        /// </summary>
        public XlsxCell Cell(string cellReference)
        {
            return new XlsxCell(_book, this, cellReference);
        }

        /// <summary>
        /// Cell
        /// </summary>
        public XlsxCell Cell(int columnIndex, int rowIndex)
        {
            return new XlsxCell(_book, this, columnIndex, rowIndex);
        }

        /// <summary>
        /// （内部使用）Row
        /// </summary>
        internal Row Row(int rowIndex)
        {
            return SheetData.Elements<Row>().FirstOrDefault(t => t.RowIndex == rowIndex);
        }

        /// <summary>
        /// （内部使用）シートにRowを追加します
        /// </summary>
        internal Row AddRow(int rowIndex)
        {
            var refRow = SheetData.Elements<Row>().FirstOrDefault(t=>t.RowIndex > rowIndex);
            var newRow = new Row() { RowIndex = (uint)rowIndex };
            return SheetData.InsertBefore<Row>(newRow, refRow);
        }

        /// <summary>
        /// （内部使用）Cell
        /// </summary>
        internal Cell Cell(Row row, string cellReference)
        {
            return row.Elements<Cell>().Where(c => c.CellReference.Value == cellReference).FirstOrDefault();
        }

        /// <summary>
        /// （内部使用）シートにCellを追加します
        /// </summary>
        internal Cell AddCell(Row row, string cellReference)
        {
            Cell refCell = row.Elements<Cell>().FirstOrDefault(t => CompareCellReference(t.CellReference.Value, cellReference) > 0);
            Cell newCell = new Cell() { CellReference = cellReference };
            return row.InsertBefore<Cell>(newCell, refCell);
        }

        /// <summary>
        /// セル参照の大小を比較し、 cellRef1 > cellRef2 の場合は正、cellRef1 < cellRef2 は負、cellRef1 = cellRef2 は0を返します。
        /// </summary>
        private static int CompareCellReference(string cellRef1, string cellRef2)
        {
            for (int i = 1; i < cellRef1.Length && i < cellRef2.Length; i++)
            {
                var c1 = cellRef1[i];
                var c2 = cellRef2[i];
                var b1 = ('A' <= c1  && c1 <= 'Z');
                var b2 = ('A' <= c2  && c2 <= 'Z');
                if (b1 == false && b2 == false) break;
                if (b1 == true && b2 == false) return 1;
                if (b1 == false && b2 == true) return -1;
            }

            return string.Compare(cellRef1, cellRef2);
        }
    }
}
